#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>
#define ios ios::sync_with_stdio(false); cin.tie(0); cout.tie(0);
#define endl '\n'
using namespace std;
using namespace __gnu_pbds;

typedef tree<pair<int,int>, null_type, less<pair<int,int>>, rb_tree_tag, tree_order_statistics_node_update> os;
typedef unsigned long long ull;
typedef long long ll;
mt19937 rng(chrono::high_resolution_clock::now().time_since_epoch().count());

ll kvad_duz(ll a, ll b){
    return a*a + b*b;
}

struct UgaoIndeks {
    double ugao;
    int indeks;
};

bool uporediUgao(const UgaoIndeks& a, const UgaoIndeks& b) {
    return a.ugao < b.ugao;
}

int main(){
    ios;
    int n;
    cin >> n;

    vector<pair<ll, ll>> v(n);
    for(int i = 0; i < n; i++) {
        cin >> v[i].first >> v[i].second;
    }

    vector<UgaoIndeks> uglovi(n);
    for(int i = 0; i < n; i++){
        uglovi[i].ugao = atan2(v[i].second, v[i].first);
        uglovi[i].indeks = i;
    }

    sort(uglovi.begin(), uglovi.end(), uporediUgao);

    vector<UgaoIndeks> prosireni_uglovi = uglovi;
    for(int i = 0; i < n; i++) {
        prosireni_uglovi.push_back({uglovi[i].ugao + 2.0*M_PI, uglovi[i].indeks});
    }

    ll tx = 0;
    ll ty = 0;
    ll max_kvad = 0;

    pair<int, int> rez = {-1, -1};
    int d = 0;

    for(int l = 0; l < n; l++){

        while(d < l + n && prosireni_uglovi[d].ugao - prosireni_uglovi[l].ugao <= M_PI){

            int ind_d = prosireni_uglovi[d].indeks;

            tx += v[ind_d].first;
            ty += v[ind_d].second;

            ll tr = kvad_duz(tx, ty);

            if(tr > max_kvad){
                max_kvad = tr;
                rez = {l, d};
            }

            d++;
        }

        if (l < d) {
            int ind_l = prosireni_uglovi[l].indeks;
            tx -= v[ind_l].first;
            ty -= v[ind_l].second;
        } else {
             d = l + 1;
        }
    }

    if (rez.first == -1) {
         cout << 0 << endl;
         return 0;
    }

    cout << rez.second - rez.first + 1 << endl;

    vector<int> konacni_indeksi;
    for(int i = rez.first; i <= rez.second; i++){
        konacni_indeksi.push_back(prosireni_uglovi[i].indeks + 1);
    }

    sort(konacni_indeksi.begin(), konacni_indeksi.end());

    for(int i = 0; i < konacni_indeksi.size(); i++) {
        cout << konacni_indeksi[i] << (i == konacni_indeksi.size() - 1 ? "" : " ");
    }
    cout << endl;

    return 0;
}